/*
* Copyright 2021-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* SPDX-License-Identifier:  GPL-2.0+
*/
#pragma once

// MT7686-specific
#define GPIO_CODA_MODE 34  // MTK GPIO12   -> SD0_CMD       -> GPIO 34

// MT7933-specific
#define GPIO_CTR_GPIO_B_2  29 // GPIO_B_2  -> PAD_SD0_GPIO0 -> GPIO 29
#define GPIO_CTR_GPIO_B_12 30 // GPIO_B_12 -> PAD_SD0_CDZ   -> GPIO 30

#ifdef TARGET_PRODUCT_ORCA
#define GPIO_WF_TX_IRQ 110 // WF_TX_IRQ    -> PAD_GPIO11    -> GPIO 110   // EVT mini rework connects WF_TX_IRQ to GPIO11 AKA GPIO 110
#else
#define GPIO_WF_TX_IRQ 43  // WF_TX_IRQ    -> PAD_I2C0_SDA  -> GPIO 43
#endif

#define GPIO_RST_WF    24  // SAV_RST_WF   -> PAD_SAR_GPIO1 -> GPIO 24
#define GPIO_PWR_ENB   11  // SAV_PWR_ENB  -> PAD_PM_GPIO5  -> GPIO 11
#define GPIO_FUART_TX  9   // SAV_FUART_TX -> PAD_PM_GPIO3  -> GPIO  9
#define GPIO_FUART_RX  8   // SAV_FUART_RX -> PAD_PM_GPIO2  -> GPIO  8
